/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.util.plugins;

import com.google.common.collect.Lists;
import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.items.ItemPristineMatter;
import com.yollo.dmlreforged.core.configs.MobConfig;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import com.yollo.dmlreforged.core.util.plugins.ExtractionChamberRecipeCategory;
import com.yollo.dmlreforged.core.util.plugins.ExtractionChamberRecipes;
import com.yollo.dmlreforged.core.util.plugins.SimulationChamberRecipeCategory;
import com.yollo.dmlreforged.core.util.plugins.SimulationChamberRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIMain
implements IModPlugin {
    private static ResourceLocation id = new ResourceLocation("dmlreforged", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ExtractionChamberRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SimulationChamberRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addExtractionChamberRecipe(registration);
        this.addSimulationChamberRecipe(registration);
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ItemInit.GLITCH_INGOT.get()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.dmlreforged.glitch_ingot")});
    }

    private void addSimulationChamberRecipe(IRecipeRegistration registration) {
        ArrayList list = Lists.newArrayList();
        ItemInit.ITEMS.getEntries().forEach(stack -> {
            Object patt2039$temp = stack.get();
            if (patt2039$temp instanceof ItemDataModel) {
                ItemDataModel dataModel = (ItemDataModel)((Object)((Object)patt2039$temp));
                ItemStack dataStack = new ItemStack((ItemLike)dataModel);
                DataModelHelper.setTier(dataStack, 1);
                list.add(new SimulationChamberRecipes(dataStack));
            }
        });
        registration.addRecipes(SimulationChamberRecipeCategory.type, (List)list);
    }

    private void addExtractionChamberRecipe(IRecipeRegistration registration) {
        HashMap<ItemStack, NonNullList> pristineTables = new HashMap<ItemStack, NonNullList>();
        ArrayList list = Lists.newArrayList();
        ItemInit.ITEMS.getEntries().forEach(stack -> {
            Object patt2617$temp = stack.get();
            if (patt2617$temp instanceof ItemPristineMatter) {
                ItemPristineMatter matter = (ItemPristineMatter)((Object)((Object)patt2617$temp));
                pristineTables.put(new ItemStack((ItemLike)matter, 1), MobConfig.getLootTable(matter.getMobKey()));
            }
        });
        pristineTables.forEach((input, outputs) -> outputs.forEach(output -> list.add(new ExtractionChamberRecipes((ItemStack)input, (ItemStack)output))));
        registration.addRecipes(ExtractionChamberRecipeCategory.type, (List)list);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemInit.EXTRACTION_CHAMBER_ITEM.get()), new RecipeType[]{ExtractionChamberRecipeCategory.type});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemInit.SIMULATION_CHAMBER_ITEM.get()), new RecipeType[]{SimulationChamberRecipeCategory.type});
    }

    public ResourceLocation getPluginUid() {
        return id;
    }
}

